<?php
class ConnectionManager_Base
{
	/**
	 * Cached Connection objects
	 * @type Array
	 */
	protected $cache = array();

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsData;

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsIdByName = array();


	/**
	 * An array storing the correspondence between project
	 * datasource tables names and connections ids
	 * @type Array
	 */
	protected $_tablesConnectionIds;


	/**
	 * @constructor
	 */
	function __construct()
	{
		$this->_setConnectionsData();
		$this->_setTablesConnectionIds();
	}

	/**
	 * Get connection id by the table name
	 * @param String tName
	 * @return Connection
	 */
	public function getTableConnId( $tName )
	{
		return $this->_tablesConnectionIds[ $tName ];
	}


	/**
	 * Get connection object by the table name
	 * @param String tName
	 * @return Connection
	 */
	public function byTable( $tName )
	{
		$connId = $this->_tablesConnectionIds[ $tName ];
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}

	/**
	 * Get connection object by the connection name
	 * @param String connName
	 * @return Connection
	 */
	public function byName( $connName )
	{
		$connId = $this->getIdByName( $connName );
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}

	/**
	 * Get connection id by the connection name
	 * @param String connName
	 * @return String
	 */
	protected function getIdByName( $connName )
	{
		return $this->_connectionsIdByName[ $connName ];
	}

	/**
	 * Get connection object by the connection id
	 * @param String connId
	 * @return Connection
	 */
	public function byId( $connId )
	{
		if( !isset( $this->cache[ $connId ] ) ) {
			$conn = $this->getConnection( $connId );
			if( !$conn ) {
				global $restApis;
				$conn = $restApis->getConnection( $connId );
			}
			if( !$conn ) {
				$conn = $this->getDefault();
			}
			$this->cache[ $connId ] = $conn;
		}

		return $this->cache[ $connId ];
	}

	/**
	 * Get the default db connection class
	 * @return Connection
	 */
	public function getDefault()
	{
		return $this->byId( "starport_at_localhost" );
	}

	/**
	 * Get the default db connection id
	 * @return String
	 */
	public function getDefaultConnId()
	{
		return "starport_at_localhost";
	}



	/**
	 * Get the users table db connection
	 * @return Connection
	 */
	public function getForLogin() {
		return $this->byId( $this->getLoginConnId() );
	}

	public function getLoginConnId() {
		return "starport_at_localhost";
	}


	/**
	 * Get the log table db connection
	 * @return Connection
	 */
	public function getForAudit()
	{
		return $this->byId( "starport_at_localhost" );
	}

	/**
	 * Get the locking table db connection
	 * @return Connection
	 */
	public function getForLocking()
	{
		return $this->getDefault();
	}

	/**
	 * Get the 'ug_groups' table db connection
	 * @return Connection
	 */
	public function getForUserGroups() {
		return $this->byId( $this->getUserGroupsConnId() );
	}

	public function getUserGroupsConnId() {
		return "starport_at_localhost";
	}

	/**
	 * Get the saved searches table db connection
	 * @return Connection
	 */
	public function getForSavedSearches()
	{
		return $this->byId( $this->getSavedSearchesConnId() );
	}
	
	/**
	 * Get the saved searches table db connection
	 * @return Connection
	 */
	public function getSavedSearchesConnId()
	{
		return "starport_at_localhost";
	}	

	/**
	 * Get the webreports tables db connection
	 * @return Connection
	 */
	public function getForWebReports() 
	{
		return $this->byId( $this->getSavedSearchesConnId() );
	}

	/**
	 * Get the webreports tables db connection id
	 * @return String
	 */
	public function getWebReportsConnId() {
		return "starport_at_localhost";
	}	
	
	/**
	 * @param String connId
	 * @return Connection
	 */
	protected function getConnection( $connId )
	{
		return false;
	}

	public function getConectionsIds()
	{
		$connectionsIds = array();
		foreach ($this->_connectionsData as $connId => $data) {
			$connectionsIds[] = $connId;
		}

		return $connectionsIds;
	}

	/**
	 * Set the data representing the project's
	 * db connection properties
	 */
	protected function _setConnectionsData()
	{
        return null;
	}

	/**
	 * Set the data representing the correspondence between
	 * the project's table names and db connections
	 */
	protected function _setTablesConnectionIds()
	{
		$connectionsIds = array();
		$connectionsIds["products"] = "starport_at_localhost";
		$connectionsIds["product_menu"] = "starport_at_localhost";
		$connectionsIds["types"] = "starport_at_localhost";
		$connectionsIds["feature_products"] = "starport_at_localhost";
		$connectionsIds["sellers"] = "starport_at_localhost";
		$connectionsIds["driver"] = "starport_at_localhost";
		$connectionsIds["location"] = "starport_at_localhost";
		$connectionsIds["dlvry_status"] = "starport_at_localhost";
		$connectionsIds["order_form"] = "starport_at_localhost";
		$connectionsIds["order_form_details"] = "starport_at_localhost";
		$connectionsIds["payment_method"] = "starport_at_localhost";
		$connectionsIds["pickup_method"] = "starport_at_localhost";
		$connectionsIds["report_center"] = "starport_at_localhost";
		$connectionsIds["source_of_order"] = "starport_at_localhost";
		$connectionsIds["transactions"] = "starport_at_localhost";
		$connectionsIds["system_user"] = "starport_at_localhost";
		$connectionsIds["trucks"] = "starport_at_localhost";
		$connectionsIds["Pending Orders"] = "starport_at_localhost";
		$connectionsIds["Preparing Orders"] = "starport_at_localhost";
		$connectionsIds["For Delivery"] = "starport_at_localhost";
		$connectionsIds["For Receiving"] = "starport_at_localhost";
		$connectionsIds["rpaf"] = "starport_at_localhost";
		$connectionsIds["fees"] = "starport_at_localhost";
		$connectionsIds["customers"] = "starport_at_localhost";
		$connectionsIds["voucher"] = "starport_at_localhost";
		$connectionsIds["customers1"] = "starport_at_localhost";
		$connectionsIds["customers2"] = "starport_at_localhost";
		$connectionsIds["customers3"] = "starport_at_localhost";
		$connectionsIds["rpaf_payment"] = "starport_at_localhost";
		$connectionsIds["credit_limit"] = "starport_at_localhost";
		$connectionsIds["customers4"] = "starport_at_localhost";
		$connectionsIds["customers5"] = "starport_at_localhost";
		$connectionsIds["area"] = "starport_at_localhost";
		$connectionsIds["logistics"] = "starport_at_localhost";
		$connectionsIds["logistics_user"] = "starport_at_localhost";
		$connectionsIds["Assign Logistic"] = "starport_at_localhost";
		$connectionsIds["sellers_company"] = "starport_at_localhost";
		$connectionsIds["truck_type"] = "starport_at_localhost";
		$connectionsIds["shop_radius"] = "starport_at_localhost";
		$connectionsIds["admin_rpaf_credit_list"] = "starport_at_localhost";
		$connectionsIds["Agents"] = "starport_at_localhost";
		$connectionsIds["customers6"] = "starport_at_localhost";
		$connectionsIds["agents_details"] = "starport_at_localhost";
		$connectionsIds["agent_customer_list"] = "starport_at_localhost";
		$connectionsIds["agentView"] = "starport_at_localhost";
		$connectionsIds["seller_account_details"] = "starport_at_localhost";
		$connectionsIds["Pending Orders (Split Payments)"] = "starport_at_localhost";
		$connectionsIds["rpaf_update_history"] = "starport_at_localhost";
		$connectionsIds["rpaf1"] = "starport_at_localhost";
		$connectionsIds["rpaf2"] = "starport_at_localhost";
		$connectionsIds["date_check_tbl"] = "starport_at_localhost";
		$connectionsIds["order_form_rpaf_payment_view"] = "starport_at_localhost";
		$connectionsIds["sap_customers"] = "starport_at_localhost";
		$connectionsIds["sap_item"] = "starport_at_localhost";
		$connectionsIds["rpaf_view_balance"] = "starport_at_localhost";
		$connectionsIds["rpaf_admin_payment"] = "starport_at_localhost";
		$connectionsIds["delivered_orders"] = "starport_at_localhost";
		$connectionsIds["shipping_flagdown"] = "starport_at_localhost";
		$connectionsIds["admin_rights"] = "starport_at_localhost";
		$connectionsIds["admin_members"] = "starport_at_localhost";
		$connectionsIds["admin_users"] = "starport_at_localhost";
		$connectionsIds["announcements"] = "starport_at_localhost";
		$connectionsIds["return_order_log"] = "starport_at_localhost";
		$connectionsIds["logistic_payment"] = "starport_at_localhost";
		$connectionsIds["admin_date_check_tbl"] = "starport_at_localhost";
		$connectionsIds["logistics_payment_head1"] = "starport_at_localhost";
		$connectionsIds["logistic_payment_detail"] = "starport_at_localhost";
		$connectionsIds["logistics_company_payment_view"] = "starport_at_localhost";
		$connectionsIds["logistics_fee_orders_view"] = "starport_at_localhost";
		$connectionsIds["tbl_multiple_dr"] = "starport_at_localhost";
		$connectionsIds["rpaf_payment_head"] = "starport_at_localhost";
		$connectionsIds["rpaf_payment_head_detail"] = "starport_at_localhost";
		$connectionsIds["rpaf_payment_head_2"] = "starport_at_localhost";
		$connectionsIds["rpaf_payment_head_detail_2"] = "starport_at_localhost";
		$connectionsIds["received_orders"] = "starport_at_localhost";
		$connectionsIds["received_orders_detail"] = "starport_at_localhost";
		$connectionsIds["buildmart_admin_audit"] = "starport_at_localhost";
		$connectionsIds["voucher_expired"] = "starport_at_localhost";

		$this->_tablesConnectionIds = &$connectionsIds;
	}

	/**
	 * Check if It's possible to add to one table's sql query
	 * an sql subquery to another table.
	 * Access doesn't support subqueries from the same table as main.
	 * @param String dataSourceTName1
	 * @param String dataSourceTName2
	 * @return Boolean
	 */
	public function checkTablesSubqueriesSupport( $dataSourceTName1, $dataSourceTName2 )
	{
		$connId1 = $this->_tablesConnectionIds[ $dataSourceTName1 ];
		$connId2 = $this->_tablesConnectionIds[ $dataSourceTName2 ];

		if( $connId1 != $connId2 )
			return false;

		if( $this->_connectionsData[ $connId1 ]["dbType"] == nDATABASE_Access && $dataSourceTName1 == $dataSourceTName2 )
			return false;

		return true;
	}

	/**
	 * Close db connections
    */
	function CloseConnections()
	{
		foreach( $this->cache as $connection )
		{
			if( $connection )
				$connection->close();
		}
	}
}
?>