<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["order_form_details.product_id"] )) {
			$lookupTableLinks["products"]["order_form_details.product_id"] = array();
		}
		$lookupTableLinks["products"]["order_form_details.product_id"]["edit"] = array("table" => "order_form_details", "field" => "product_id", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["order_form.truck"] )) {
			$lookupTableLinks["trucks"]["order_form.truck"] = array();
		}
		$lookupTableLinks["trucks"]["order_form.truck"]["edit"] = array("table" => "order_form", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["order_form.driver"] )) {
			$lookupTableLinks["driver"]["order_form.driver"] = array();
		}
		$lookupTableLinks["driver"]["order_form.driver"]["edit"] = array("table" => "order_form", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trucks.driver_id"] )) {
			$lookupTableLinks["driver"]["trucks.driver_id"] = array();
		}
		$lookupTableLinks["driver"]["trucks.driver_id"]["edit"] = array("table" => "trucks", "field" => "driver_id", "page" => "edit");
		if( !isset( $lookupTableLinks["truck_type"] ) ) {
			$lookupTableLinks["truck_type"] = array();
		}
		if( !isset( $lookupTableLinks["truck_type"]["trucks.truck_type"] )) {
			$lookupTableLinks["truck_type"]["trucks.truck_type"] = array();
		}
		$lookupTableLinks["truck_type"]["trucks.truck_type"]["edit"] = array("table" => "trucks", "field" => "truck_type", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["trucks.logistics_id"] )) {
			$lookupTableLinks["logistics"]["trucks.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["trucks.logistics_id"]["edit"] = array("table" => "trucks", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics_area"] ) ) {
			$lookupTableLinks["logistics_area"] = array();
		}
		if( !isset( $lookupTableLinks["logistics_area"]["trucks.group_id"] )) {
			$lookupTableLinks["logistics_area"]["trucks.group_id"] = array();
		}
		$lookupTableLinks["logistics_area"]["trucks.group_id"]["edit"] = array("table" => "trucks", "field" => "group_id", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["driver.logistics_id"] )) {
			$lookupTableLinks["logistics"]["driver.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["driver.logistics_id"]["edit"] = array("table" => "driver", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["location.vehicle_id"] )) {
			$lookupTableLinks["trucks"]["location.vehicle_id"] = array();
		}
		$lookupTableLinks["trucks"]["location.vehicle_id"]["edit"] = array("table" => "location", "field" => "vehicle_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["for_delivery.driver"] )) {
			$lookupTableLinks["driver"]["for_delivery.driver"] = array();
		}
		$lookupTableLinks["driver"]["for_delivery.driver"]["edit"] = array("table" => "For Delivery", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["for_delivery.truck"] )) {
			$lookupTableLinks["trucks"]["for_delivery.truck"] = array();
		}
		$lookupTableLinks["trucks"]["for_delivery.truck"]["edit"] = array("table" => "For Delivery", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["for_delivery.logistics_id"] )) {
			$lookupTableLinks["logistics"]["for_delivery.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["for_delivery.logistics_id"]["edit"] = array("table" => "For Delivery", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["delivered.driver"] )) {
			$lookupTableLinks["driver"]["delivered.driver"] = array();
		}
		$lookupTableLinks["driver"]["delivered.driver"]["edit"] = array("table" => "Delivered", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["delivered.truck"] )) {
			$lookupTableLinks["trucks"]["delivered.truck"] = array();
		}
		$lookupTableLinks["trucks"]["delivered.truck"]["edit"] = array("table" => "Delivered", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["delivered.logistics_id"] )) {
			$lookupTableLinks["logistics"]["delivered.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["delivered.logistics_id"]["edit"] = array("table" => "Delivered", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["logistics_user.logistics_id"] )) {
			$lookupTableLinks["logistics"]["logistics_user.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["logistics_user.logistics_id"]["edit"] = array("table" => "logistics_user", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trucks_tracking.driver_id"] )) {
			$lookupTableLinks["driver"]["trucks_tracking.driver_id"] = array();
		}
		$lookupTableLinks["driver"]["trucks_tracking.driver_id"]["edit"] = array("table" => "Trucks Tracking", "field" => "driver_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["for_pickup.driver"] )) {
			$lookupTableLinks["driver"]["for_pickup.driver"] = array();
		}
		$lookupTableLinks["driver"]["for_pickup.driver"]["edit"] = array("table" => "For Pickup", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["for_pickup.truck"] )) {
			$lookupTableLinks["trucks"]["for_pickup.truck"] = array();
		}
		$lookupTableLinks["trucks"]["for_pickup.truck"]["edit"] = array("table" => "For Pickup", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["for_pickup.logistics_id"] )) {
			$lookupTableLinks["logistics"]["for_pickup.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["for_pickup.logistics_id"]["edit"] = array("table" => "For Pickup", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["truck_type.logistics_id"] )) {
			$lookupTableLinks["logistics"]["truck_type.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["truck_type.logistics_id"]["edit"] = array("table" => "truck_type", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["for_delivery__warehouse_.driver"] )) {
			$lookupTableLinks["driver"]["for_delivery__warehouse_.driver"] = array();
		}
		$lookupTableLinks["driver"]["for_delivery__warehouse_.driver"]["edit"] = array("table" => "For Delivery (Warehouse)", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["for_delivery__warehouse_.truck"] )) {
			$lookupTableLinks["trucks"]["for_delivery__warehouse_.truck"] = array();
		}
		$lookupTableLinks["trucks"]["for_delivery__warehouse_.truck"]["edit"] = array("table" => "For Delivery (Warehouse)", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["for_delivery__warehouse_.logistics_id"] )) {
			$lookupTableLinks["logistics"]["for_delivery__warehouse_.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["for_delivery__warehouse_.logistics_id"]["edit"] = array("table" => "For Delivery (Warehouse)", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["biiling.driver"] )) {
			$lookupTableLinks["driver"]["biiling.driver"] = array();
		}
		$lookupTableLinks["driver"]["biiling.driver"]["edit"] = array("table" => "Biiling", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["biiling.truck"] )) {
			$lookupTableLinks["trucks"]["biiling.truck"] = array();
		}
		$lookupTableLinks["trucks"]["biiling.truck"]["edit"] = array("table" => "Biiling", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trip_chart_overall.driver"] )) {
			$lookupTableLinks["driver"]["trip_chart_overall.driver"] = array();
		}
		$lookupTableLinks["driver"]["trip_chart_overall.driver"]["search"] = array("table" => "trip_chart_overall", "field" => "driver", "page" => "search");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["trip_chart_overall.truck"] )) {
			$lookupTableLinks["trucks"]["trip_chart_overall.truck"] = array();
		}
		$lookupTableLinks["trucks"]["trip_chart_overall.truck"]["search"] = array("table" => "trip_chart_overall", "field" => "truck", "page" => "search");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trip_chart_daily.driver"] )) {
			$lookupTableLinks["driver"]["trip_chart_daily.driver"] = array();
		}
		$lookupTableLinks["driver"]["trip_chart_daily.driver"]["search"] = array("table" => "trip_chart_daily", "field" => "driver", "page" => "search");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["trip_chart_daily.truck"] )) {
			$lookupTableLinks["trucks"]["trip_chart_daily.truck"] = array();
		}
		$lookupTableLinks["trucks"]["trip_chart_daily.truck"]["search"] = array("table" => "trip_chart_daily", "field" => "truck", "page" => "search");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trip_chart_weekly.driver"] )) {
			$lookupTableLinks["driver"]["trip_chart_weekly.driver"] = array();
		}
		$lookupTableLinks["driver"]["trip_chart_weekly.driver"]["search"] = array("table" => "trip_chart_weekly", "field" => "driver", "page" => "search");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["trip_chart_weekly.truck"] )) {
			$lookupTableLinks["trucks"]["trip_chart_weekly.truck"] = array();
		}
		$lookupTableLinks["trucks"]["trip_chart_weekly.truck"]["search"] = array("table" => "trip_chart_weekly", "field" => "truck", "page" => "search");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trip_chart_monthly.driver"] )) {
			$lookupTableLinks["driver"]["trip_chart_monthly.driver"] = array();
		}
		$lookupTableLinks["driver"]["trip_chart_monthly.driver"]["search"] = array("table" => "trip_chart_monthly", "field" => "driver", "page" => "search");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["trip_chart_monthly.truck"] )) {
			$lookupTableLinks["trucks"]["trip_chart_monthly.truck"] = array();
		}
		$lookupTableLinks["trucks"]["trip_chart_monthly.truck"]["search"] = array("table" => "trip_chart_monthly", "field" => "truck", "page" => "search");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["logistics_area.logistics_id"] )) {
			$lookupTableLinks["logistics"]["logistics_area.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["logistics_area.logistics_id"]["edit"] = array("table" => "logistics_area", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trip_chart_daily_per_area.driver"] )) {
			$lookupTableLinks["driver"]["trip_chart_daily_per_area.driver"] = array();
		}
		$lookupTableLinks["driver"]["trip_chart_daily_per_area.driver"]["search"] = array("table" => "trip_chart_daily_per_area", "field" => "driver", "page" => "search");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["trip_chart_daily_per_area.truck"] )) {
			$lookupTableLinks["trucks"]["trip_chart_daily_per_area.truck"] = array();
		}
		$lookupTableLinks["trucks"]["trip_chart_daily_per_area.truck"]["search"] = array("table" => "trip_chart_daily_per_area", "field" => "truck", "page" => "search");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trip_chart_monthly_per_area.driver"] )) {
			$lookupTableLinks["driver"]["trip_chart_monthly_per_area.driver"] = array();
		}
		$lookupTableLinks["driver"]["trip_chart_monthly_per_area.driver"]["search"] = array("table" => "trip_chart_monthly_per_area", "field" => "driver", "page" => "search");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["trip_chart_monthly_per_area.truck"] )) {
			$lookupTableLinks["trucks"]["trip_chart_monthly_per_area.truck"] = array();
		}
		$lookupTableLinks["trucks"]["trip_chart_monthly_per_area.truck"]["search"] = array("table" => "trip_chart_monthly_per_area", "field" => "truck", "page" => "search");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trip_chart_overall_per_area.driver"] )) {
			$lookupTableLinks["driver"]["trip_chart_overall_per_area.driver"] = array();
		}
		$lookupTableLinks["driver"]["trip_chart_overall_per_area.driver"]["search"] = array("table" => "trip_chart_overall_per_area", "field" => "driver", "page" => "search");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["trip_chart_overall_per_area.truck"] )) {
			$lookupTableLinks["trucks"]["trip_chart_overall_per_area.truck"] = array();
		}
		$lookupTableLinks["trucks"]["trip_chart_overall_per_area.truck"]["search"] = array("table" => "trip_chart_overall_per_area", "field" => "truck", "page" => "search");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trip_chart_weekly_per_area.driver"] )) {
			$lookupTableLinks["driver"]["trip_chart_weekly_per_area.driver"] = array();
		}
		$lookupTableLinks["driver"]["trip_chart_weekly_per_area.driver"]["search"] = array("table" => "trip_chart_weekly_per_area", "field" => "driver", "page" => "search");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["trip_chart_weekly_per_area.truck"] )) {
			$lookupTableLinks["trucks"]["trip_chart_weekly_per_area.truck"] = array();
		}
		$lookupTableLinks["trucks"]["trip_chart_weekly_per_area.truck"]["search"] = array("table" => "trip_chart_weekly_per_area", "field" => "truck", "page" => "search");
}

?>