<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["order_form.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["order_form.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["order_form.pickup_method"]["edit"] = array("table" => "order_form", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["order_form.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["order_form.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["order_form.mode_of_payment"]["edit"] = array("table" => "order_form", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["order_form.payment_method"] )) {
			$lookupTableLinks["payment_method"]["order_form.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["order_form.payment_method"]["edit"] = array("table" => "order_form", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["order_form.seller_id"] )) {
			$lookupTableLinks["sellers"]["order_form.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["order_form.seller_id"]["edit"] = array("table" => "order_form", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["order_form.driver"] )) {
			$lookupTableLinks["driver"]["order_form.driver"] = array();
		}
		$lookupTableLinks["driver"]["order_form.driver"]["edit"] = array("table" => "order_form", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["order_form.truck"] )) {
			$lookupTableLinks["trucks"]["order_form.truck"] = array();
		}
		$lookupTableLinks["trucks"]["order_form.truck"]["edit"] = array("table" => "order_form", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["types"] ) ) {
			$lookupTableLinks["types"] = array();
		}
		if( !isset( $lookupTableLinks["types"]["products.type_id"] )) {
			$lookupTableLinks["types"]["products.type_id"] = array();
		}
		$lookupTableLinks["types"]["products.type_id"]["edit"] = array("table" => "products", "field" => "type_id", "page" => "edit");
		if( !isset( $lookupTableLinks["product_menu"] ) ) {
			$lookupTableLinks["product_menu"] = array();
		}
		if( !isset( $lookupTableLinks["product_menu"]["products.menu_id"] )) {
			$lookupTableLinks["product_menu"]["products.menu_id"] = array();
		}
		$lookupTableLinks["product_menu"]["products.menu_id"]["edit"] = array("table" => "products", "field" => "menu_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["products.seller_id"] )) {
			$lookupTableLinks["sellers"]["products.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["products.seller_id"]["edit"] = array("table" => "products", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["customers.sponsor_id"] )) {
			$lookupTableLinks["sellers"]["customers.sponsor_id"] = array();
		}
		$lookupTableLinks["sellers"]["customers.sponsor_id"]["edit"] = array("table" => "customers", "field" => "sponsor_id", "page" => "edit");
		if( !isset( $lookupTableLinks["product_menu"] ) ) {
			$lookupTableLinks["product_menu"] = array();
		}
		if( !isset( $lookupTableLinks["product_menu"]["feature_products.menu_id"] )) {
			$lookupTableLinks["product_menu"]["feature_products.menu_id"] = array();
		}
		$lookupTableLinks["product_menu"]["feature_products.menu_id"]["edit"] = array("table" => "feature_products", "field" => "menu_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["sellers.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["sellers.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["sellers.seller_id"]["edit"] = array("table" => "sellers", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["order_form_details.product_id"] )) {
			$lookupTableLinks["products"]["order_form_details.product_id"] = array();
		}
		$lookupTableLinks["products"]["order_form_details.product_id"]["edit"] = array("table" => "order_form_details", "field" => "product_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["pending_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["pending_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["pending_orders.pickup_method"]["edit"] = array("table" => "Pending Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["pending_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["pending_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["pending_orders.mode_of_payment"]["edit"] = array("table" => "Pending Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["pending_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["pending_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["pending_orders.payment_method"]["edit"] = array("table" => "Pending Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["pending_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["pending_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["pending_orders.seller_id"]["edit"] = array("table" => "Pending Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["preparing_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["preparing_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["preparing_orders.pickup_method"]["edit"] = array("table" => "Preparing Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["preparing_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["preparing_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["preparing_orders.mode_of_payment"]["edit"] = array("table" => "Preparing Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["preparing_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["preparing_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["preparing_orders.payment_method"]["edit"] = array("table" => "Preparing Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["preparing_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["preparing_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["preparing_orders.seller_id"]["edit"] = array("table" => "Preparing Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["delivered_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["delivered_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["delivered_orders.pickup_method"]["edit"] = array("table" => "Delivered Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["delivered_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["delivered_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["delivered_orders.mode_of_payment"]["edit"] = array("table" => "Delivered Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["delivered_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["delivered_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["delivered_orders.payment_method"]["edit"] = array("table" => "Delivered Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["delivered_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["delivered_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["delivered_orders.seller_id"]["edit"] = array("table" => "Delivered Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["customer_pickup_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["customer_pickup_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["customer_pickup_orders.pickup_method"]["edit"] = array("table" => "Customer Pickup Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["customer_pickup_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["customer_pickup_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["customer_pickup_orders.mode_of_payment"]["edit"] = array("table" => "Customer Pickup Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["customer_pickup_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["customer_pickup_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["customer_pickup_orders.payment_method"]["edit"] = array("table" => "Customer Pickup Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["customer_pickup_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["customer_pickup_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["customer_pickup_orders.seller_id"]["edit"] = array("table" => "Customer Pickup Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["voucher.agent"] )) {
			$lookupTableLinks["customers"]["voucher.agent"] = array();
		}
		$lookupTableLinks["customers"]["voucher.agent"]["edit"] = array("table" => "voucher", "field" => "agent", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["received_orders.customer_id"] )) {
			$lookupTableLinks["customers"]["received_orders.customer_id"] = array();
		}
		$lookupTableLinks["customers"]["received_orders.customer_id"]["edit"] = array("table" => "Received Orders", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["received_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["received_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["received_orders.pickup_method"]["edit"] = array("table" => "Received Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["received_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["received_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["received_orders.mode_of_payment"]["edit"] = array("table" => "Received Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["received_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["received_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["received_orders.payment_method"]["edit"] = array("table" => "Received Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["received_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["received_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["received_orders.seller_id"]["edit"] = array("table" => "Received Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["received_orders.driver"] )) {
			$lookupTableLinks["driver"]["received_orders.driver"] = array();
		}
		$lookupTableLinks["driver"]["received_orders.driver"]["edit"] = array("table" => "Received Orders", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["received_orders.truck"] )) {
			$lookupTableLinks["trucks"]["received_orders.truck"] = array();
		}
		$lookupTableLinks["trucks"]["received_orders.truck"]["edit"] = array("table" => "Received Orders", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["preparing_orders__customer_pickup_.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["preparing_orders__customer_pickup_.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["preparing_orders__customer_pickup_.pickup_method"]["edit"] = array("table" => "Preparing Orders (Customer Pickup)", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["preparing_orders__customer_pickup_.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["preparing_orders__customer_pickup_.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["preparing_orders__customer_pickup_.mode_of_payment"]["edit"] = array("table" => "Preparing Orders (Customer Pickup)", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["preparing_orders__customer_pickup_.payment_method"] )) {
			$lookupTableLinks["payment_method"]["preparing_orders__customer_pickup_.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["preparing_orders__customer_pickup_.payment_method"]["edit"] = array("table" => "Preparing Orders (Customer Pickup)", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["preparing_orders__customer_pickup_.seller_id"] )) {
			$lookupTableLinks["sellers"]["preparing_orders__customer_pickup_.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["preparing_orders__customer_pickup_.seller_id"]["edit"] = array("table" => "Preparing Orders (Customer Pickup)", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["preparing_orders__customer_pickup_.driver"] )) {
			$lookupTableLinks["driver"]["preparing_orders__customer_pickup_.driver"] = array();
		}
		$lookupTableLinks["driver"]["preparing_orders__customer_pickup_.driver"]["edit"] = array("table" => "Preparing Orders (Customer Pickup)", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["preparing_orders__customer_pickup_.truck"] )) {
			$lookupTableLinks["trucks"]["preparing_orders__customer_pickup_.truck"] = array();
		}
		$lookupTableLinks["trucks"]["preparing_orders__customer_pickup_.truck"]["edit"] = array("table" => "Preparing Orders (Customer Pickup)", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["types"] ) ) {
			$lookupTableLinks["types"] = array();
		}
		if( !isset( $lookupTableLinks["types"]["product_parent.type_id"] )) {
			$lookupTableLinks["types"]["product_parent.type_id"] = array();
		}
		$lookupTableLinks["types"]["product_parent.type_id"]["edit"] = array("table" => "product_parent", "field" => "type_id", "page" => "edit");
		if( !isset( $lookupTableLinks["product_menu"] ) ) {
			$lookupTableLinks["product_menu"] = array();
		}
		if( !isset( $lookupTableLinks["product_menu"]["product_parent.menu_id"] )) {
			$lookupTableLinks["product_menu"]["product_parent.menu_id"] = array();
		}
		$lookupTableLinks["product_menu"]["product_parent.menu_id"]["edit"] = array("table" => "product_parent", "field" => "menu_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["product_parent.seller_id"] )) {
			$lookupTableLinks["sellers"]["product_parent.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["product_parent.seller_id"]["edit"] = array("table" => "product_parent", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["types"] ) ) {
			$lookupTableLinks["types"] = array();
		}
		if( !isset( $lookupTableLinks["types"]["products_child.type_id"] )) {
			$lookupTableLinks["types"]["products_child.type_id"] = array();
		}
		$lookupTableLinks["types"]["products_child.type_id"]["edit"] = array("table" => "products_child", "field" => "type_id", "page" => "edit");
		if( !isset( $lookupTableLinks["product_menu"] ) ) {
			$lookupTableLinks["product_menu"] = array();
		}
		if( !isset( $lookupTableLinks["product_menu"]["products_child.menu_id"] )) {
			$lookupTableLinks["product_menu"]["products_child.menu_id"] = array();
		}
		$lookupTableLinks["product_menu"]["products_child.menu_id"]["edit"] = array("table" => "products_child", "field" => "menu_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["products_child.seller_id"] )) {
			$lookupTableLinks["sellers"]["products_child.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["products_child.seller_id"]["edit"] = array("table" => "products_child", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["sellers_child.parent_company"] )) {
			$lookupTableLinks["sellers_company"]["sellers_child.parent_company"] = array();
		}
		$lookupTableLinks["sellers_company"]["sellers_child.parent_company"]["edit"] = array("table" => "sellers_child", "field" => "parent_company", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["child_sellers.parent_company"] )) {
			$lookupTableLinks["sellers_company"]["child_sellers.parent_company"] = array();
		}
		$lookupTableLinks["sellers_company"]["child_sellers.parent_company"]["edit"] = array("table" => "child_sellers", "field" => "parent_company", "page" => "edit");
		if( !isset( $lookupTableLinks["types"] ) ) {
			$lookupTableLinks["types"] = array();
		}
		if( !isset( $lookupTableLinks["types"]["child_products.type_id"] )) {
			$lookupTableLinks["types"]["child_products.type_id"] = array();
		}
		$lookupTableLinks["types"]["child_products.type_id"]["edit"] = array("table" => "child_products", "field" => "type_id", "page" => "edit");
		if( !isset( $lookupTableLinks["product_menu"] ) ) {
			$lookupTableLinks["product_menu"] = array();
		}
		if( !isset( $lookupTableLinks["product_menu"]["child_products.menu_id"] )) {
			$lookupTableLinks["product_menu"]["child_products.menu_id"] = array();
		}
		$lookupTableLinks["product_menu"]["child_products.menu_id"]["edit"] = array("table" => "child_products", "field" => "menu_id", "page" => "edit");
		if( !isset( $lookupTableLinks["child_seller_company"] ) ) {
			$lookupTableLinks["child_seller_company"] = array();
		}
		if( !isset( $lookupTableLinks["child_seller_company"]["child_products.seller_id"] )) {
			$lookupTableLinks["child_seller_company"]["child_products.seller_id"] = array();
		}
		$lookupTableLinks["child_seller_company"]["child_products.seller_id"]["edit"] = array("table" => "child_products", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["child_products.company_name"] )) {
			$lookupTableLinks["sellers_company"]["child_products.company_name"] = array();
		}
		$lookupTableLinks["sellers_company"]["child_products.company_name"]["edit"] = array("table" => "child_products", "field" => "company_name", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["child_pending_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["child_pending_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["child_pending_orders.pickup_method"]["edit"] = array("table" => "Child Pending Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_pending_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["child_pending_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["child_pending_orders.mode_of_payment"]["edit"] = array("table" => "Child Pending Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_pending_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["child_pending_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["child_pending_orders.payment_method"]["edit"] = array("table" => "Child Pending Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["child_pending_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["child_pending_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["child_pending_orders.seller_id"]["edit"] = array("table" => "Child Pending Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["child_preparing_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["child_preparing_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["child_preparing_orders.pickup_method"]["edit"] = array("table" => "Child Preparing Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_preparing_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["child_preparing_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["child_preparing_orders.mode_of_payment"]["edit"] = array("table" => "Child Preparing Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_preparing_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["child_preparing_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["child_preparing_orders.payment_method"]["edit"] = array("table" => "Child Preparing Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["child_preparing_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["child_preparing_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["child_preparing_orders.seller_id"]["edit"] = array("table" => "Child Preparing Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["child_preparing_orders__customer_pickup_.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["child_preparing_orders__customer_pickup_.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["child_preparing_orders__customer_pickup_.pickup_method"]["edit"] = array("table" => "Child Preparing Orders (Customer Pickup)", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_preparing_orders__customer_pickup_.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["child_preparing_orders__customer_pickup_.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["child_preparing_orders__customer_pickup_.mode_of_payment"]["edit"] = array("table" => "Child Preparing Orders (Customer Pickup)", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_preparing_orders__customer_pickup_.payment_method"] )) {
			$lookupTableLinks["payment_method"]["child_preparing_orders__customer_pickup_.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["child_preparing_orders__customer_pickup_.payment_method"]["edit"] = array("table" => "Child Preparing Orders (Customer Pickup)", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["child_preparing_orders__customer_pickup_.seller_id"] )) {
			$lookupTableLinks["sellers"]["child_preparing_orders__customer_pickup_.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["child_preparing_orders__customer_pickup_.seller_id"]["edit"] = array("table" => "Child Preparing Orders (Customer Pickup)", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["child_preparing_orders__customer_pickup_.driver"] )) {
			$lookupTableLinks["driver"]["child_preparing_orders__customer_pickup_.driver"] = array();
		}
		$lookupTableLinks["driver"]["child_preparing_orders__customer_pickup_.driver"]["edit"] = array("table" => "Child Preparing Orders (Customer Pickup)", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["child_preparing_orders__customer_pickup_.truck"] )) {
			$lookupTableLinks["trucks"]["child_preparing_orders__customer_pickup_.truck"] = array();
		}
		$lookupTableLinks["trucks"]["child_preparing_orders__customer_pickup_.truck"]["edit"] = array("table" => "Child Preparing Orders (Customer Pickup)", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["child_customer_pickup_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["child_customer_pickup_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["child_customer_pickup_orders.pickup_method"]["edit"] = array("table" => "Child Customer Pickup Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_customer_pickup_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["child_customer_pickup_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["child_customer_pickup_orders.mode_of_payment"]["edit"] = array("table" => "Child Customer Pickup Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_customer_pickup_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["child_customer_pickup_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["child_customer_pickup_orders.payment_method"]["edit"] = array("table" => "Child Customer Pickup Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["child_customer_pickup_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["child_customer_pickup_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["child_customer_pickup_orders.seller_id"]["edit"] = array("table" => "Child Customer Pickup Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["child_received_orders.customer_id"] )) {
			$lookupTableLinks["customers"]["child_received_orders.customer_id"] = array();
		}
		$lookupTableLinks["customers"]["child_received_orders.customer_id"]["edit"] = array("table" => "Child Received Orders", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["child_received_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["child_received_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["child_received_orders.pickup_method"]["edit"] = array("table" => "Child Received Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_received_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["child_received_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["child_received_orders.mode_of_payment"]["edit"] = array("table" => "Child Received Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_received_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["child_received_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["child_received_orders.payment_method"]["edit"] = array("table" => "Child Received Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["child_received_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["child_received_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["child_received_orders.seller_id"]["edit"] = array("table" => "Child Received Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["child_received_orders.driver"] )) {
			$lookupTableLinks["driver"]["child_received_orders.driver"] = array();
		}
		$lookupTableLinks["driver"]["child_received_orders.driver"]["edit"] = array("table" => "Child Received Orders", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["child_received_orders.truck"] )) {
			$lookupTableLinks["trucks"]["child_received_orders.truck"] = array();
		}
		$lookupTableLinks["trucks"]["child_received_orders.truck"]["edit"] = array("table" => "Child Received Orders", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["child_delivered_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["child_delivered_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["child_delivered_orders.pickup_method"]["edit"] = array("table" => "Child Delivered Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_delivered_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["child_delivered_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["child_delivered_orders.mode_of_payment"]["edit"] = array("table" => "Child Delivered Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_delivered_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["child_delivered_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["child_delivered_orders.payment_method"]["edit"] = array("table" => "Child Delivered Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["child_delivered_orders.seller_id"] )) {
			$lookupTableLinks["sellers"]["child_delivered_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["child_delivered_orders.seller_id"]["edit"] = array("table" => "Child Delivered Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["child_order_form.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["child_order_form.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["child_order_form.pickup_method"]["edit"] = array("table" => "child_order_form", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_order_form.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["child_order_form.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["child_order_form.mode_of_payment"]["edit"] = array("table" => "child_order_form", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["child_order_form.payment_method"] )) {
			$lookupTableLinks["payment_method"]["child_order_form.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["child_order_form.payment_method"]["edit"] = array("table" => "child_order_form", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["child_order_form.seller_id"] )) {
			$lookupTableLinks["sellers"]["child_order_form.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["child_order_form.seller_id"]["edit"] = array("table" => "child_order_form", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["child_order_form.driver"] )) {
			$lookupTableLinks["driver"]["child_order_form.driver"] = array();
		}
		$lookupTableLinks["driver"]["child_order_form.driver"]["edit"] = array("table" => "child_order_form", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["child_order_form.truck"] )) {
			$lookupTableLinks["trucks"]["child_order_form.truck"] = array();
		}
		$lookupTableLinks["trucks"]["child_order_form.truck"]["edit"] = array("table" => "child_order_form", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["child_voucher.agent"] )) {
			$lookupTableLinks["customers"]["child_voucher.agent"] = array();
		}
		$lookupTableLinks["customers"]["child_voucher.agent"]["edit"] = array("table" => "child_voucher", "field" => "agent", "page" => "edit");
		if( !isset( $lookupTableLinks["child_seller_company"] ) ) {
			$lookupTableLinks["child_seller_company"] = array();
		}
		if( !isset( $lookupTableLinks["child_seller_company"]["child_voucher.seller_voucher"] )) {
			$lookupTableLinks["child_seller_company"]["child_voucher.seller_voucher"] = array();
		}
		$lookupTableLinks["child_seller_company"]["child_voucher.seller_voucher"]["edit"] = array("table" => "child_voucher", "field" => "seller_voucher", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["seller_account_detail.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["seller_account_detail.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["seller_account_detail.seller_id"]["edit"] = array("table" => "seller_account_detail", "field" => "seller_id", "page" => "edit");
}

?>