<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["types"] ) ) {
			$lookupTableLinks["types"] = array();
		}
		if( !isset( $lookupTableLinks["types"]["products.type_id"] )) {
			$lookupTableLinks["types"]["products.type_id"] = array();
		}
		$lookupTableLinks["types"]["products.type_id"]["edit"] = array("table" => "products", "field" => "type_id", "page" => "edit");
		if( !isset( $lookupTableLinks["product_menu"] ) ) {
			$lookupTableLinks["product_menu"] = array();
		}
		if( !isset( $lookupTableLinks["product_menu"]["products.menu_id"] )) {
			$lookupTableLinks["product_menu"]["products.menu_id"] = array();
		}
		$lookupTableLinks["product_menu"]["products.menu_id"]["edit"] = array("table" => "products", "field" => "menu_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["products.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["products.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["products.seller_id"]["edit"] = array("table" => "products", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["products.company_name"] )) {
			$lookupTableLinks["sellers_company"]["products.company_name"] = array();
		}
		$lookupTableLinks["sellers_company"]["products.company_name"]["edit"] = array("table" => "products", "field" => "company_name", "page" => "edit");
		if( !isset( $lookupTableLinks["sap_item"] ) ) {
			$lookupTableLinks["sap_item"] = array();
		}
		if( !isset( $lookupTableLinks["sap_item"]["products.sap_id"] )) {
			$lookupTableLinks["sap_item"]["products.sap_id"] = array();
		}
		$lookupTableLinks["sap_item"]["products.sap_id"]["edit"] = array("table" => "products", "field" => "sap_id", "page" => "edit");
		if( !isset( $lookupTableLinks["product_menu"] ) ) {
			$lookupTableLinks["product_menu"] = array();
		}
		if( !isset( $lookupTableLinks["product_menu"]["feature_products.menu_id"] )) {
			$lookupTableLinks["product_menu"]["feature_products.menu_id"] = array();
		}
		$lookupTableLinks["product_menu"]["feature_products.menu_id"]["edit"] = array("table" => "feature_products", "field" => "menu_id", "page" => "edit");
		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["feature_products.special_products"] )) {
			$lookupTableLinks["products"]["feature_products.special_products"] = array();
		}
		$lookupTableLinks["products"]["feature_products.special_products"]["edit"] = array("table" => "feature_products", "field" => "special_products", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["feature_products.vendor"] )) {
			$lookupTableLinks["sellers_company"]["feature_products.vendor"] = array();
		}
		$lookupTableLinks["sellers_company"]["feature_products.vendor"]["edit"] = array("table" => "feature_products", "field" => "vendor", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["sellers.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["sellers.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["sellers.seller_id"]["edit"] = array("table" => "sellers", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["location.vehicle_id"] )) {
			$lookupTableLinks["trucks"]["location.vehicle_id"] = array();
		}
		$lookupTableLinks["trucks"]["location.vehicle_id"]["edit"] = array("table" => "location", "field" => "vehicle_id", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["order_form.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["order_form.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["order_form.mode_of_payment"]["edit"] = array("table" => "order_form", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["order_form.payment_method"] )) {
			$lookupTableLinks["payment_method"]["order_form.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["order_form.payment_method"]["edit"] = array("table" => "order_form", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["order_form.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["order_form.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["order_form.seller_id"]["edit"] = array("table" => "order_form", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["order_form.driver"] )) {
			$lookupTableLinks["driver"]["order_form.driver"] = array();
		}
		$lookupTableLinks["driver"]["order_form.driver"]["edit"] = array("table" => "order_form", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["order_form.truck"] )) {
			$lookupTableLinks["trucks"]["order_form.truck"] = array();
		}
		$lookupTableLinks["trucks"]["order_form.truck"]["edit"] = array("table" => "order_form", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["order_form.logistics_id"] )) {
			$lookupTableLinks["logistics"]["order_form.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["order_form.logistics_id"]["edit"] = array("table" => "order_form", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["order_form_details.product_id"] )) {
			$lookupTableLinks["products"]["order_form_details.product_id"] = array();
		}
		$lookupTableLinks["products"]["order_form_details.product_id"]["edit"] = array("table" => "order_form_details", "field" => "product_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["trucks.driver_id"] )) {
			$lookupTableLinks["driver"]["trucks.driver_id"] = array();
		}
		$lookupTableLinks["driver"]["trucks.driver_id"]["edit"] = array("table" => "trucks", "field" => "driver_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["pending_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["pending_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["pending_orders.pickup_method"]["edit"] = array("table" => "Pending Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["pending_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["pending_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["pending_orders.mode_of_payment"]["edit"] = array("table" => "Pending Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["pending_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["pending_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["pending_orders.payment_method"]["edit"] = array("table" => "Pending Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["pending_orders.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["pending_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["pending_orders.seller_id"]["edit"] = array("table" => "Pending Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["pending_orders.driver"] )) {
			$lookupTableLinks["driver"]["pending_orders.driver"] = array();
		}
		$lookupTableLinks["driver"]["pending_orders.driver"]["edit"] = array("table" => "Pending Orders", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["pending_orders.truck"] )) {
			$lookupTableLinks["trucks"]["pending_orders.truck"] = array();
		}
		$lookupTableLinks["trucks"]["pending_orders.truck"]["edit"] = array("table" => "Pending Orders", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["system_user"] ) ) {
			$lookupTableLinks["system_user"] = array();
		}
		if( !isset( $lookupTableLinks["system_user"]["pending_orders.order_verified_by"] )) {
			$lookupTableLinks["system_user"]["pending_orders.order_verified_by"] = array();
		}
		$lookupTableLinks["system_user"]["pending_orders.order_verified_by"]["edit"] = array("table" => "Pending Orders", "field" => "order_verified_by", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["preparing_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["preparing_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["preparing_orders.pickup_method"]["edit"] = array("table" => "Preparing Orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["preparing_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["preparing_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["preparing_orders.mode_of_payment"]["edit"] = array("table" => "Preparing Orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["preparing_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["preparing_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["preparing_orders.payment_method"]["edit"] = array("table" => "Preparing Orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["preparing_orders.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["preparing_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["preparing_orders.seller_id"]["edit"] = array("table" => "Preparing Orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["preparing_orders.driver"] )) {
			$lookupTableLinks["driver"]["preparing_orders.driver"] = array();
		}
		$lookupTableLinks["driver"]["preparing_orders.driver"]["edit"] = array("table" => "Preparing Orders", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["preparing_orders.truck"] )) {
			$lookupTableLinks["trucks"]["preparing_orders.truck"] = array();
		}
		$lookupTableLinks["trucks"]["preparing_orders.truck"]["edit"] = array("table" => "Preparing Orders", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["preparing_orders.logistics_id"] )) {
			$lookupTableLinks["logistics"]["preparing_orders.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["preparing_orders.logistics_id"]["edit"] = array("table" => "Preparing Orders", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["for_delivery.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["for_delivery.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["for_delivery.pickup_method"]["edit"] = array("table" => "For Delivery", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["for_delivery.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["for_delivery.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["for_delivery.mode_of_payment"]["edit"] = array("table" => "For Delivery", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["for_delivery.payment_method"] )) {
			$lookupTableLinks["payment_method"]["for_delivery.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["for_delivery.payment_method"]["edit"] = array("table" => "For Delivery", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["for_delivery.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["for_delivery.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["for_delivery.seller_id"]["edit"] = array("table" => "For Delivery", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["for_delivery.driver"] )) {
			$lookupTableLinks["driver"]["for_delivery.driver"] = array();
		}
		$lookupTableLinks["driver"]["for_delivery.driver"]["edit"] = array("table" => "For Delivery", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["for_delivery.truck"] )) {
			$lookupTableLinks["trucks"]["for_delivery.truck"] = array();
		}
		$lookupTableLinks["trucks"]["for_delivery.truck"]["edit"] = array("table" => "For Delivery", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["for_delivery.logistics_id"] )) {
			$lookupTableLinks["logistics"]["for_delivery.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["for_delivery.logistics_id"]["edit"] = array("table" => "For Delivery", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["for_receiving.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["for_receiving.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["for_receiving.pickup_method"]["edit"] = array("table" => "For Receiving", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["for_receiving.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["for_receiving.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["for_receiving.mode_of_payment"]["edit"] = array("table" => "For Receiving", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["for_receiving.payment_method"] )) {
			$lookupTableLinks["payment_method"]["for_receiving.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["for_receiving.payment_method"]["edit"] = array("table" => "For Receiving", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers"] ) ) {
			$lookupTableLinks["sellers"] = array();
		}
		if( !isset( $lookupTableLinks["sellers"]["for_receiving.seller_id"] )) {
			$lookupTableLinks["sellers"]["for_receiving.seller_id"] = array();
		}
		$lookupTableLinks["sellers"]["for_receiving.seller_id"]["edit"] = array("table" => "For Receiving", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["for_receiving.driver"] )) {
			$lookupTableLinks["driver"]["for_receiving.driver"] = array();
		}
		$lookupTableLinks["driver"]["for_receiving.driver"]["edit"] = array("table" => "For Receiving", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["for_receiving.truck"] )) {
			$lookupTableLinks["trucks"]["for_receiving.truck"] = array();
		}
		$lookupTableLinks["trucks"]["for_receiving.truck"]["edit"] = array("table" => "For Receiving", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["admin_rpaf_credit_list"] ) ) {
			$lookupTableLinks["admin_rpaf_credit_list"] = array();
		}
		if( !isset( $lookupTableLinks["admin_rpaf_credit_list"]["rpaf.credit_limit"] )) {
			$lookupTableLinks["admin_rpaf_credit_list"]["rpaf.credit_limit"] = array();
		}
		$lookupTableLinks["admin_rpaf_credit_list"]["rpaf.credit_limit"]["edit"] = array("table" => "rpaf", "field" => "credit_limit", "page" => "edit");
		if( !isset( $lookupTableLinks["area"] ) ) {
			$lookupTableLinks["area"] = array();
		}
		if( !isset( $lookupTableLinks["area"]["rpaf.area"] )) {
			$lookupTableLinks["area"]["rpaf.area"] = array();
		}
		$lookupTableLinks["area"]["rpaf.area"]["edit"] = array("table" => "rpaf", "field" => "area", "page" => "edit");
		if( !isset( $lookupTableLinks["admin_date_check_tbl"] ) ) {
			$lookupTableLinks["admin_date_check_tbl"] = array();
		}
		if( !isset( $lookupTableLinks["admin_date_check_tbl"]["rpaf.credit_date_limit"] )) {
			$lookupTableLinks["admin_date_check_tbl"]["rpaf.credit_date_limit"] = array();
		}
		$lookupTableLinks["admin_date_check_tbl"]["rpaf.credit_date_limit"]["edit"] = array("table" => "rpaf", "field" => "credit_date_limit", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["rpaf.customer_id"] )) {
			$lookupTableLinks["customers"]["rpaf.customer_id"] = array();
		}
		$lookupTableLinks["customers"]["rpaf.customer_id"]["edit"] = array("table" => "rpaf", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["customers.agent_code"] )) {
			$lookupTableLinks["customers"]["customers.agent_code"] = array();
		}
		$lookupTableLinks["customers"]["customers.agent_code"]["edit"] = array("table" => "customers", "field" => "agent_code", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["customers.sponsor_id"] )) {
			$lookupTableLinks["customers"]["customers.sponsor_id"] = array();
		}
		$lookupTableLinks["customers"]["customers.sponsor_id"]["edit"] = array("table" => "customers", "field" => "sponsor_id", "page" => "edit");
		if( !isset( $lookupTableLinks["Agents"] ) ) {
			$lookupTableLinks["Agents"] = array();
		}
		if( !isset( $lookupTableLinks["Agents"]["customers.agent"] )) {
			$lookupTableLinks["Agents"]["customers.agent"] = array();
		}
		$lookupTableLinks["Agents"]["customers.agent"]["edit"] = array("table" => "customers", "field" => "agent", "page" => "edit");
		if( !isset( $lookupTableLinks["sap_customers"] ) ) {
			$lookupTableLinks["sap_customers"] = array();
		}
		if( !isset( $lookupTableLinks["sap_customers"]["customers.sap_id"] )) {
			$lookupTableLinks["sap_customers"]["customers.sap_id"] = array();
		}
		$lookupTableLinks["sap_customers"]["customers.sap_id"]["edit"] = array("table" => "customers", "field" => "sap_id", "page" => "edit");
		if( !isset( $lookupTableLinks["customers3"] ) ) {
			$lookupTableLinks["customers3"] = array();
		}
		if( !isset( $lookupTableLinks["customers3"]["voucher.agent"] )) {
			$lookupTableLinks["customers3"]["voucher.agent"] = array();
		}
		$lookupTableLinks["customers3"]["voucher.agent"]["edit"] = array("table" => "voucher", "field" => "agent", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["voucher.seller_voucher"] )) {
			$lookupTableLinks["sellers_company"]["voucher.seller_voucher"] = array();
		}
		$lookupTableLinks["sellers_company"]["voucher.seller_voucher"]["edit"] = array("table" => "voucher", "field" => "seller_voucher", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["voucher.parent_company_id"] )) {
			$lookupTableLinks["sellers_company"]["voucher.parent_company_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["voucher.parent_company_id"]["edit"] = array("table" => "voucher", "field" => "parent_company_id", "page" => "edit");
		if( !isset( $lookupTableLinks["order_form_rpaf_payment_view"] ) ) {
			$lookupTableLinks["order_form_rpaf_payment_view"] = array();
		}
		if( !isset( $lookupTableLinks["order_form_rpaf_payment_view"]["rpaf_payment.order_id"] )) {
			$lookupTableLinks["order_form_rpaf_payment_view"]["rpaf_payment.order_id"] = array();
		}
		$lookupTableLinks["order_form_rpaf_payment_view"]["rpaf_payment.order_id"]["edit"] = array("table" => "rpaf_payment", "field" => "order_id", "page" => "edit");
		if( !isset( $lookupTableLinks["rpaf2"] ) ) {
			$lookupTableLinks["rpaf2"] = array();
		}
		if( !isset( $lookupTableLinks["rpaf2"]["rpaf_payment.customer_id"] )) {
			$lookupTableLinks["rpaf2"]["rpaf_payment.customer_id"] = array();
		}
		$lookupTableLinks["rpaf2"]["rpaf_payment.customer_id"]["edit"] = array("table" => "rpaf_payment", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["logistics_user.logistics_id"] )) {
			$lookupTableLinks["logistics"]["logistics_user.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["logistics_user.logistics_id"]["edit"] = array("table" => "logistics_user", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["assign_logistic.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["assign_logistic.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["assign_logistic.pickup_method"]["edit"] = array("table" => "Assign Logistic", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["assign_logistic.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["assign_logistic.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["assign_logistic.mode_of_payment"]["edit"] = array("table" => "Assign Logistic", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["assign_logistic.payment_method"] )) {
			$lookupTableLinks["payment_method"]["assign_logistic.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["assign_logistic.payment_method"]["edit"] = array("table" => "Assign Logistic", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["assign_logistic.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["assign_logistic.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["assign_logistic.seller_id"]["edit"] = array("table" => "Assign Logistic", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["assign_logistic.driver"] )) {
			$lookupTableLinks["driver"]["assign_logistic.driver"] = array();
		}
		$lookupTableLinks["driver"]["assign_logistic.driver"]["edit"] = array("table" => "Assign Logistic", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["assign_logistic.truck"] )) {
			$lookupTableLinks["trucks"]["assign_logistic.truck"] = array();
		}
		$lookupTableLinks["trucks"]["assign_logistic.truck"]["edit"] = array("table" => "Assign Logistic", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["assign_logistic.logistics_id"] )) {
			$lookupTableLinks["logistics"]["assign_logistic.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["assign_logistic.logistics_id"]["edit"] = array("table" => "Assign Logistic", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["sellers_company.parent_company"] )) {
			$lookupTableLinks["sellers_company"]["sellers_company.parent_company"] = array();
		}
		$lookupTableLinks["sellers_company"]["sellers_company.parent_company"]["edit"] = array("table" => "sellers_company", "field" => "parent_company", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["truck_type.logistics_id"] )) {
			$lookupTableLinks["logistics"]["truck_type.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["truck_type.logistics_id"]["edit"] = array("table" => "truck_type", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["customers6.sponsor_id"] )) {
			$lookupTableLinks["customers"]["customers6.sponsor_id"] = array();
		}
		$lookupTableLinks["customers"]["customers6.sponsor_id"]["edit"] = array("table" => "customers6", "field" => "sponsor_id", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["customers6.agent"] )) {
			$lookupTableLinks["customers"]["customers6.agent"] = array();
		}
		$lookupTableLinks["customers"]["customers6.agent"]["edit"] = array("table" => "customers6", "field" => "agent", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["agents_details.sponsor_id"] )) {
			$lookupTableLinks["customers"]["agents_details.sponsor_id"] = array();
		}
		$lookupTableLinks["customers"]["agents_details.sponsor_id"]["edit"] = array("table" => "agents_details", "field" => "sponsor_id", "page" => "edit");
		if( !isset( $lookupTableLinks["Agents"] ) ) {
			$lookupTableLinks["Agents"] = array();
		}
		if( !isset( $lookupTableLinks["Agents"]["agents_details.agent"] )) {
			$lookupTableLinks["Agents"]["agents_details.agent"] = array();
		}
		$lookupTableLinks["Agents"]["agents_details.agent"]["edit"] = array("table" => "agents_details", "field" => "agent", "page" => "edit");
		if( !isset( $lookupTableLinks["agentView"] ) ) {
			$lookupTableLinks["agentView"] = array();
		}
		if( !isset( $lookupTableLinks["agentView"]["agent_customer_list.agent"] )) {
			$lookupTableLinks["agentView"]["agent_customer_list.agent"] = array();
		}
		$lookupTableLinks["agentView"]["agent_customer_list.agent"]["edit"] = array("table" => "agent_customer_list", "field" => "agent", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["agent_customer_list.customer"] )) {
			$lookupTableLinks["customers"]["agent_customer_list.customer"] = array();
		}
		$lookupTableLinks["customers"]["agent_customer_list.customer"]["edit"] = array("table" => "agent_customer_list", "field" => "customer", "page" => "edit");
		if( !isset( $lookupTableLinks["Agents"] ) ) {
			$lookupTableLinks["Agents"] = array();
		}
		if( !isset( $lookupTableLinks["Agents"]["agentview.agent"] )) {
			$lookupTableLinks["Agents"]["agentview.agent"] = array();
		}
		$lookupTableLinks["Agents"]["agentview.agent"]["edit"] = array("table" => "agentView", "field" => "agent", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["agentview.sponsor_id"] )) {
			$lookupTableLinks["customers"]["agentview.sponsor_id"] = array();
		}
		$lookupTableLinks["customers"]["agentview.sponsor_id"]["edit"] = array("table" => "agentView", "field" => "sponsor_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["seller_account_details.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["seller_account_details.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["seller_account_details.seller_id"]["edit"] = array("table" => "seller_account_details", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["pending_orders__split_payments_.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["pending_orders__split_payments_.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["pending_orders__split_payments_.pickup_method"]["edit"] = array("table" => "Pending Orders (Split Payments)", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["pending_orders__split_payments_.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["pending_orders__split_payments_.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["pending_orders__split_payments_.mode_of_payment"]["edit"] = array("table" => "Pending Orders (Split Payments)", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["pending_orders__split_payments_.payment_method"] )) {
			$lookupTableLinks["payment_method"]["pending_orders__split_payments_.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["pending_orders__split_payments_.payment_method"]["edit"] = array("table" => "Pending Orders (Split Payments)", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["pending_orders__split_payments_.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["pending_orders__split_payments_.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["pending_orders__split_payments_.seller_id"]["edit"] = array("table" => "Pending Orders (Split Payments)", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["pending_orders__split_payments_.driver"] )) {
			$lookupTableLinks["driver"]["pending_orders__split_payments_.driver"] = array();
		}
		$lookupTableLinks["driver"]["pending_orders__split_payments_.driver"]["edit"] = array("table" => "Pending Orders (Split Payments)", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["pending_orders__split_payments_.truck"] )) {
			$lookupTableLinks["trucks"]["pending_orders__split_payments_.truck"] = array();
		}
		$lookupTableLinks["trucks"]["pending_orders__split_payments_.truck"]["edit"] = array("table" => "Pending Orders (Split Payments)", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["system_user"] ) ) {
			$lookupTableLinks["system_user"] = array();
		}
		if( !isset( $lookupTableLinks["system_user"]["pending_orders__split_payments_.order_verified_by"] )) {
			$lookupTableLinks["system_user"]["pending_orders__split_payments_.order_verified_by"] = array();
		}
		$lookupTableLinks["system_user"]["pending_orders__split_payments_.order_verified_by"]["edit"] = array("table" => "Pending Orders (Split Payments)", "field" => "order_verified_by", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["rpaf1.customer_id"] )) {
			$lookupTableLinks["customers"]["rpaf1.customer_id"] = array();
		}
		$lookupTableLinks["customers"]["rpaf1.customer_id"]["edit"] = array("table" => "rpaf1", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["rpaf2.customer_id"] )) {
			$lookupTableLinks["customers"]["rpaf2.customer_id"] = array();
		}
		$lookupTableLinks["customers"]["rpaf2.customer_id"]["edit"] = array("table" => "rpaf2", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["order_form_rpaf_payment_view.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["order_form_rpaf_payment_view.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["order_form_rpaf_payment_view.pickup_method"]["edit"] = array("table" => "order_form_rpaf_payment_view", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["order_form_rpaf_payment_view.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["order_form_rpaf_payment_view.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["order_form_rpaf_payment_view.mode_of_payment"]["edit"] = array("table" => "order_form_rpaf_payment_view", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["order_form_rpaf_payment_view.payment_method"] )) {
			$lookupTableLinks["payment_method"]["order_form_rpaf_payment_view.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["order_form_rpaf_payment_view.payment_method"]["edit"] = array("table" => "order_form_rpaf_payment_view", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["order_form_rpaf_payment_view.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["order_form_rpaf_payment_view.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["order_form_rpaf_payment_view.seller_id"]["edit"] = array("table" => "order_form_rpaf_payment_view", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["order_form_rpaf_payment_view.driver"] )) {
			$lookupTableLinks["driver"]["order_form_rpaf_payment_view.driver"] = array();
		}
		$lookupTableLinks["driver"]["order_form_rpaf_payment_view.driver"]["edit"] = array("table" => "order_form_rpaf_payment_view", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["order_form_rpaf_payment_view.truck"] )) {
			$lookupTableLinks["trucks"]["order_form_rpaf_payment_view.truck"] = array();
		}
		$lookupTableLinks["trucks"]["order_form_rpaf_payment_view.truck"]["edit"] = array("table" => "order_form_rpaf_payment_view", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["customers"] ) ) {
			$lookupTableLinks["customers"] = array();
		}
		if( !isset( $lookupTableLinks["customers"]["rpaf_admin_payment.customer_id"] )) {
			$lookupTableLinks["customers"]["rpaf_admin_payment.customer_id"] = array();
		}
		$lookupTableLinks["customers"]["rpaf_admin_payment.customer_id"]["edit"] = array("table" => "rpaf_admin_payment", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["pickup_method"] ) ) {
			$lookupTableLinks["pickup_method"] = array();
		}
		if( !isset( $lookupTableLinks["pickup_method"]["delivered_orders.pickup_method"] )) {
			$lookupTableLinks["pickup_method"]["delivered_orders.pickup_method"] = array();
		}
		$lookupTableLinks["pickup_method"]["delivered_orders.pickup_method"]["edit"] = array("table" => "delivered_orders", "field" => "pickup_method", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["delivered_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["delivered_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["delivered_orders.mode_of_payment"]["edit"] = array("table" => "delivered_orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["delivered_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["delivered_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["delivered_orders.payment_method"]["edit"] = array("table" => "delivered_orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["delivered_orders.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["delivered_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["delivered_orders.seller_id"]["edit"] = array("table" => "delivered_orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["delivered_orders.driver"] )) {
			$lookupTableLinks["driver"]["delivered_orders.driver"] = array();
		}
		$lookupTableLinks["driver"]["delivered_orders.driver"]["edit"] = array("table" => "delivered_orders", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["delivered_orders.truck"] )) {
			$lookupTableLinks["trucks"]["delivered_orders.truck"] = array();
		}
		$lookupTableLinks["trucks"]["delivered_orders.truck"]["edit"] = array("table" => "delivered_orders", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["delivered_orders.logistics_id"] )) {
			$lookupTableLinks["logistics"]["delivered_orders.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["delivered_orders.logistics_id"]["edit"] = array("table" => "delivered_orders", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["shipping_flagdown.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["shipping_flagdown.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["shipping_flagdown.seller_id"]["edit"] = array("table" => "shipping_flagdown", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["return_order_log.product_id"] )) {
			$lookupTableLinks["products"]["return_order_log.product_id"] = array();
		}
		$lookupTableLinks["products"]["return_order_log.product_id"]["edit"] = array("table" => "return_order_log", "field" => "product_id", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["logistic_payment.customer_id"] )) {
			$lookupTableLinks["logistics"]["logistic_payment.customer_id"] = array();
		}
		$lookupTableLinks["logistics"]["logistic_payment.customer_id"]["edit"] = array("table" => "logistic_payment", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["logistic_payment.logistics_id"] )) {
			$lookupTableLinks["logistics"]["logistic_payment.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["logistic_payment.logistics_id"]["edit"] = array("table" => "logistic_payment", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["logistic_payment_detail.customer_id"] )) {
			$lookupTableLinks["logistics"]["logistic_payment_detail.customer_id"] = array();
		}
		$lookupTableLinks["logistics"]["logistic_payment_detail.customer_id"]["edit"] = array("table" => "logistic_payment_detail", "field" => "customer_id", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["logistic_payment_detail.logistics_id"] )) {
			$lookupTableLinks["logistics"]["logistic_payment_detail.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["logistic_payment_detail.logistics_id"]["edit"] = array("table" => "logistic_payment_detail", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["logistics_fee_orders_view.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["logistics_fee_orders_view.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["logistics_fee_orders_view.mode_of_payment"]["edit"] = array("table" => "logistics_fee_orders_view", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["logistics_fee_orders_view.payment_method"] )) {
			$lookupTableLinks["payment_method"]["logistics_fee_orders_view.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["logistics_fee_orders_view.payment_method"]["edit"] = array("table" => "logistics_fee_orders_view", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["logistics_fee_orders_view.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["logistics_fee_orders_view.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["logistics_fee_orders_view.seller_id"]["edit"] = array("table" => "logistics_fee_orders_view", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["logistics_fee_orders_view.driver"] )) {
			$lookupTableLinks["driver"]["logistics_fee_orders_view.driver"] = array();
		}
		$lookupTableLinks["driver"]["logistics_fee_orders_view.driver"]["edit"] = array("table" => "logistics_fee_orders_view", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["logistics_fee_orders_view.truck"] )) {
			$lookupTableLinks["trucks"]["logistics_fee_orders_view.truck"] = array();
		}
		$lookupTableLinks["trucks"]["logistics_fee_orders_view.truck"]["edit"] = array("table" => "logistics_fee_orders_view", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["logistics_fee_orders_view.logistics_id"] )) {
			$lookupTableLinks["logistics"]["logistics_fee_orders_view.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["logistics_fee_orders_view.logistics_id"]["edit"] = array("table" => "logistics_fee_orders_view", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["order_form_rpaf_payment_view"] ) ) {
			$lookupTableLinks["order_form_rpaf_payment_view"] = array();
		}
		if( !isset( $lookupTableLinks["order_form_rpaf_payment_view"]["rpaf_payment_head_detail.order_id"] )) {
			$lookupTableLinks["order_form_rpaf_payment_view"]["rpaf_payment_head_detail.order_id"] = array();
		}
		$lookupTableLinks["order_form_rpaf_payment_view"]["rpaf_payment_head_detail.order_id"]["edit"] = array("table" => "rpaf_payment_head_detail", "field" => "order_id", "page" => "edit");
		if( !isset( $lookupTableLinks["order_form_rpaf_payment_view"] ) ) {
			$lookupTableLinks["order_form_rpaf_payment_view"] = array();
		}
		if( !isset( $lookupTableLinks["order_form_rpaf_payment_view"]["rpaf_payment_head_detail_2.order_id"] )) {
			$lookupTableLinks["order_form_rpaf_payment_view"]["rpaf_payment_head_detail_2.order_id"] = array();
		}
		$lookupTableLinks["order_form_rpaf_payment_view"]["rpaf_payment_head_detail_2.order_id"]["edit"] = array("table" => "rpaf_payment_head_detail_2", "field" => "order_id", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["received_orders.mode_of_payment"] )) {
			$lookupTableLinks["payment_method"]["received_orders.mode_of_payment"] = array();
		}
		$lookupTableLinks["payment_method"]["received_orders.mode_of_payment"]["edit"] = array("table" => "received_orders", "field" => "mode_of_payment", "page" => "edit");
		if( !isset( $lookupTableLinks["payment_method"] ) ) {
			$lookupTableLinks["payment_method"] = array();
		}
		if( !isset( $lookupTableLinks["payment_method"]["received_orders.payment_method"] )) {
			$lookupTableLinks["payment_method"]["received_orders.payment_method"] = array();
		}
		$lookupTableLinks["payment_method"]["received_orders.payment_method"]["edit"] = array("table" => "received_orders", "field" => "payment_method", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["received_orders.seller_id"] )) {
			$lookupTableLinks["sellers_company"]["received_orders.seller_id"] = array();
		}
		$lookupTableLinks["sellers_company"]["received_orders.seller_id"]["edit"] = array("table" => "received_orders", "field" => "seller_id", "page" => "edit");
		if( !isset( $lookupTableLinks["driver"] ) ) {
			$lookupTableLinks["driver"] = array();
		}
		if( !isset( $lookupTableLinks["driver"]["received_orders.driver"] )) {
			$lookupTableLinks["driver"]["received_orders.driver"] = array();
		}
		$lookupTableLinks["driver"]["received_orders.driver"]["edit"] = array("table" => "received_orders", "field" => "driver", "page" => "edit");
		if( !isset( $lookupTableLinks["trucks"] ) ) {
			$lookupTableLinks["trucks"] = array();
		}
		if( !isset( $lookupTableLinks["trucks"]["received_orders.truck"] )) {
			$lookupTableLinks["trucks"]["received_orders.truck"] = array();
		}
		$lookupTableLinks["trucks"]["received_orders.truck"]["edit"] = array("table" => "received_orders", "field" => "truck", "page" => "edit");
		if( !isset( $lookupTableLinks["logistics"] ) ) {
			$lookupTableLinks["logistics"] = array();
		}
		if( !isset( $lookupTableLinks["logistics"]["received_orders.logistics_id"] )) {
			$lookupTableLinks["logistics"]["received_orders.logistics_id"] = array();
		}
		$lookupTableLinks["logistics"]["received_orders.logistics_id"]["edit"] = array("table" => "received_orders", "field" => "logistics_id", "page" => "edit");
		if( !isset( $lookupTableLinks["products"] ) ) {
			$lookupTableLinks["products"] = array();
		}
		if( !isset( $lookupTableLinks["products"]["received_orders_detail.product_id"] )) {
			$lookupTableLinks["products"]["received_orders_detail.product_id"] = array();
		}
		$lookupTableLinks["products"]["received_orders_detail.product_id"]["edit"] = array("table" => "received_orders_detail", "field" => "product_id", "page" => "edit");
		if( !isset( $lookupTableLinks["customers3"] ) ) {
			$lookupTableLinks["customers3"] = array();
		}
		if( !isset( $lookupTableLinks["customers3"]["voucher_expired.agent"] )) {
			$lookupTableLinks["customers3"]["voucher_expired.agent"] = array();
		}
		$lookupTableLinks["customers3"]["voucher_expired.agent"]["edit"] = array("table" => "voucher_expired", "field" => "agent", "page" => "edit");
		if( !isset( $lookupTableLinks["sellers_company"] ) ) {
			$lookupTableLinks["sellers_company"] = array();
		}
		if( !isset( $lookupTableLinks["sellers_company"]["voucher_expired.seller_voucher"] )) {
			$lookupTableLinks["sellers_company"]["voucher_expired.seller_voucher"] = array();
		}
		$lookupTableLinks["sellers_company"]["voucher_expired.seller_voucher"]["edit"] = array("table" => "voucher_expired", "field" => "seller_voucher", "page" => "edit");
}

?>